import { ElMessage, ElMessageBox } from "element-plus";
import { ElMessageBoxOptions, MessageBoxData } from "element-plus/es/components/message-box/src/message-box.type";
import { MessageTypedFn } from "element-plus/es/components/message/src/message";

type IMessage = Parameters<MessageTypedFn>[0];

export function infoMessage(info: IMessage) {
  return ElMessage.info(info);
}
export function successMessage(info: IMessage) {
  return ElMessage.success(info);
}
export function warningMessage(info: IMessage) {
  return ElMessage.warning(info);
}
export function errorMessage(info: IMessage) {
  return ElMessage.error(info);
}

export function IPrompt(title: string, message: string, config?: ElMessageBoxOptions): Promise<MessageBoxData> {
  return ElMessageBox.prompt(message, title, config);
}

export function IConfirm(title: string, message: string, config?: ElMessageBoxOptions) {
  return ElMessageBox.confirm(message, title, config);
}

export function IWarningConfirm(title: string, message: string, config?: ElMessageBoxOptions) {
  return IConfirm(title, message, {
    ...config,
    type: "warning",
  });
}
